<section id="<?= $section_data["id"] ?? "" ?>" class="bg-white py-24" data-aos="fade-up" data-aos-duration="1000">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="text-3xl md:text-4xl mb-12 tracking-widest " data-aos="fade-right" data-aos-delay="200"><?= $section_data["title"] ?? "Gallery" ?></h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
            <?php foreach ($section_data["galleries"] ?? [] as $key => $image) : ?>
                <?php if($key == 0) { ?>
                <a href="<?= base_url()?><?= $image["link"] ?? "#"?>" data-lightbox="<?= variables()["title"] ?? "" ?>-gallery" class="row-span-2 col-span-2 " data-aos="zoom-in" data-aos-delay="300" class="glightbox"> 
                    <img src="<?= base_url()?><?= $image["link"] ?? "#"?>" class="w-full h-full object-cover rounded-xl shadow-md hover:opacity-90 transition">
                </a>
                <?php } else { ?>
                <a href="<?= base_url()?><?= $image["link"] ?? "#"?>" data-lightbox="<?= variables()["title"] ?? "" ?>-gallery" data-aos="fade-left" data-aos-delay="400" class="glightbox">
                    <img src="<?= base_url()?><?= $image["link"] ?? "#"?>" class="w-full h-full object-cover rounded-xl shadow-md hover:opacity-90 transition">
                </a>
                <?php } ?>
            <?php endforeach; ?>
        </div>
    </div>
</section>