<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<section id="room_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/twobedroompoolvilla/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Two Bedroom Private Pool Villa</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Exceptional Comfort In The Tropics</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Bali, Indonesia</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<section id="room_detail_content" class="py-24 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-center">
            <!-- Left Content -->
            <div class="space-y-8" data-aos="fade-right" data-aos-duration="1000">
                <div>
                    <h2 class="font-primary text-5xl lg:text-6xl font-light gradient-text leading-tight mb-6">TWO BEDROOM PRIVATE POOL VILLA</h2>
                    <div class="accent-line mb-8"></div>
                </div>
                <div class="space-y-6 font-body text-gray-700 text-lg leading-relaxed">
                    <p class="font-light" data-aos="fade-up" data-aos-delay="200">
                   Cozy Tropical Bedroom with Private Bathroom. Experience maximum comfort in this beautifully designed bedroom with tropical modern vibes and natural wooden</p>
                </div>
            </div>

            <!-- Right Image -->
            <div class="relative" data-aos="fade-left" data-aos-duration="1000">
                <div class="aspect-[4/3] luxury-border rounded-2xl overflow-hidden luxury-shadow">
                    <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url()?>assets/img/twobedroompoolvilla/1.jpg');">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php render(__DIR__ . '/../components/galleries.php', [
    "section_data" => [
        "id" => "room_detail_gallery",
        "title" => "Room Gallery",
        "galleries" => [
            [
                "link" => "assets/img/twobedroompoolvilla/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/4.jpg",
                "text" => ""
            ],
        ]
    ]
]) ?>

<section id="room_detail_facilities" class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
            <div data-aos="fade-up" data-aos-delay="50">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Information</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• King (200x200) / 2 Single ( 100x200)</p>
                    <p>• Up to 3 Adults</p>
                    
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="100">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Facilities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• 2 Comfortable Bedrooms with 1 Ensuite Bathrooms</p>
                    <p>• 2 Modern Bathrooms </p>
                    <p>• Spacious Enclosed Living Room</p>
                    <p>• Indoor Dining Area with Garden View</p>
                    <p>• Fully Equipped Kitchen</p>
                    <p>• Laundry Area (Washer Included)</p>
                    <p>• Storage Room</p>
                    <p>• Private Garden with Tropical Vibes</p>
                    <p>• Private Swimming Pool with Bean Bags on Pool Deck</p>
                    <p>• Carport (1 Car)</p>
                    <p>• 6-meter Paved Access Road</p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="200">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Other Room Facilities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Smart TV in Living Room</p>
                    <p>• High-Speed Wi-Fi (up to 200 mbps)</p>
                    <p>• Air Conditioning in All Rooms</p>
                    
                    
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="300">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Amenities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Safety Box in All Bedrooms</p>
                    <p>• Linen, Towels, Kitchenware Included</p>
                    <p>• Secure Gate & CCTV (1 gate system)</p>
                    <p>• Bright Natural Lighting with Floor-to-Ceiling Windows</p>
                </div>
            </div>
        </div>
    </div>
</section> 

<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>